<?php
/**
 * Online Players
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

echo '<div class="page-title"><span>'.lang('onlineplayers_title',true).'</span></div>';

try {
	
	$OnlinePlayers = new \Plugin\OnlinePlayers\OnlinePlayers();
	
	$onlinePlayersList = $OnlinePlayers->getOnlinePlayersCache();
	if(!is_array($onlinePlayersList)) throw new Exception(lang('onlineplayers_error_2',true));
	
	echo '<table class="table rankings-table">';
		echo '<tr>';
			if($OnlinePlayers->showClass()) echo '<td class="text-center">'.lang('onlineplayers_txt_1',true).'</td>';
			echo '<td>'.lang('onlineplayers_txt_2',true).'</td>';
			if($OnlinePlayers->showLevel()) echo '<td class="text-center">'.lang('onlineplayers_txt_3',true).'</td>';
			if(!$OnlinePlayers->combineMasterLevel()) if($OnlinePlayers->showMasterLevel()) echo '<td class="text-center">'.lang('onlineplayers_txt_4',true).'</td>';
			if($OnlinePlayers->showGuild()) echo '<td class="text-center">'.lang('onlineplayers_txt_5',true).'</td>';
			if($OnlinePlayers->showLocation()) echo '<td class="text-center">'.lang('onlineplayers_txt_6',true).'</td>';
		echo '</tr>';
		foreach($onlinePlayersList as $row) {
			$characterIMG = getPlayerClassAvatar($row[_CLMN_CHR_CLASS_], true, true, 'rankings-class-image');
			
			if($OnlinePlayers->combineMasterLevel()) {
				$row[_CLMN_CHR_LVL_] += $row[_CLMN_ML_LVL_];
			}
			echo '<tr>';
				if($OnlinePlayers->showClass()) echo '<td class="text-center">'.$characterIMG.'</td>';
				echo '<td>'.playerProfile($row[_CLMN_CHR_NAME_]).'<img src="'.__PATH_ONLINE_STATUS__.'" class="online-status-indicator"/></td>';
				if($OnlinePlayers->showLevel()) echo '<td class="text-center">'.number_format($row[_CLMN_CHR_LVL_]).'</td>';
				if(!$OnlinePlayers->combineMasterLevel()) if($OnlinePlayers->showMasterLevel()) echo '<td class="text-center">'.number_format($row[_CLMN_ML_LVL_]).'</td>';
				if($OnlinePlayers->showGuild()) echo '<td class="text-center">'.guildProfile($row[_CLMN_GUILDMEMB_NAME_]).'</td>';
				if($OnlinePlayers->showLocation()) echo '<td class="text-center">'.returnMapName($row[_CLMN_CHR_MAP_]).'</td>';
			echo '</tr>';
		}
	echo '</table>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}